// Spikes Deformer - extends points along path edges based on falloff

function visitAllMeshes(mesh, func) {
    for (var i = 0; i < mesh.childMeshCount(); i++) {
        var child = mesh.getChildMeshAtIndex(i);
        visitAllMeshes(child, func);
        mesh.setChildMeshAtIndex(i, child);
    }
    func(mesh);
}

function addSpikesToMesh(mesh) {
    var pathCount = mesh.count();
    for (var p = 0; p < pathCount; p++) {
        var path = mesh.getPathAtIndex(p);
        if (!path || path.empty()) {
            continue;
        }

        // Resample the path for more even point distribution
        path.resample(resample);

        var pd = path.pathData();
        for (var idx = 0; idx < pd.length; idx++) {
            // Only spike every Nth point
            if (idx % frequency !== 0) {
                continue;
            }

            // Skip entries without valid point/normal data
            if (!pd[idx] || !pd[idx].point || !pd[idx].normal) {
                continue;
            }

            var pt = pd[idx].point;
            var normal = pd[idx].normal;

            // Get falloff value at this position (includes strength)
            var falloff = def.getFalloffAtPoint(pt.x, pt.y);
            if (falloff <= 0) {
                continue;
            }

            // Extend point along its normal
            var extension = spikeLength * falloff;
            pd[idx].point.x += normal.x * extension;
            pd[idx].point.y += normal.y * extension;
        }

        path.setPathData(pd);
        mesh.setPathAtIndex(p, path);
    }
}

var root = def.getRootMesh();
visitAllMeshes(root, addSpikesToMesh);
def.setRootMesh(root);
